/*
 * Decompiled with CFR 0.152.
 */
package datastore.loader;

import datastore.loader.DatLoaderConstants;
import datastore.loader.DatLoaderTokenManager;
import datastore.loader.ParseException;
import datastore.loader.SimpleCharStream;
import datastore.loader.Token;
import datastore.rasc.SecData;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class DatLoader
implements DatLoaderConstants {
    public DatLoaderTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[4];
    private static int[] jj_la1_0;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public final void parseDat(SecData data) throws ParseException {
        String event = "";
        boolean finishedWell = false;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block9;
                }
            }
            String wellName = this.wellName();
            if (wellName.compareToIgnoreCase("LAST") == 0) {
                return;
            }
            SecData.SectionRow secRow = data.getRow(wellName, true);
            event = "";
            finishedWell = false;
            block10: while (!finishedWell) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.jj_consume_token(2);
                        continue block10;
                    }
                    case 1: {
                        event = this.get4String();
                        if (event.compareToIgnoreCase("-999") != 0) {
                            int id;
                            boolean buddy;
                            boolean bl = buddy = (event = event.trim()).charAt(0) == '-';
                            if (buddy) {
                                event = event.substring(1).trim();
                            }
                            try {
                                id = Integer.parseInt(event);
                            }
                            catch (NumberFormatException ex) {
                                throw new ParseException("'" + event + "' is not a number, even though one was expected.\r\nAre you sure the DAT file has -999 where it should and\r\nthat there are no extra blank lines (DON'T USE NOTEPAD to check for extra lines, Wordpad is ok)?");
                            }
                            secRow.datData.addWellData(buddy, id, 0.0f);
                            continue block10;
                        }
                        finishedWell = true;
                        continue block10;
                    }
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.getWholeLine();
        }
    }

    public final String wellName() throws ParseException {
        String name = this.getWholeLine();
        return name.trim();
    }

    public final String getString(int numChars) throws ParseException {
        String ret = "";
        block3: while (true) {
            Token t = this.jj_consume_token(1);
            ret = ret + t.toString();
            if (--numChars == 0) {
                return ret;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        return ret;
    }

    public final String get4String() throws ParseException {
        String ret = "";
        Token t = this.jj_consume_token(1);
        ret = ret + t.toString();
        t = this.jj_consume_token(1);
        ret = ret + t.toString();
        t = this.jj_consume_token(1);
        ret = ret + t.toString();
        t = this.jj_consume_token(1);
        ret = ret + t.toString();
        return ret;
    }

    public final String getWholeLine() throws ParseException {
        String ret = "";
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            Token t = this.jj_consume_token(1);
            ret = ret + t.toString();
        }
        this.jj_consume_token(2);
        return ret;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{6, 6, 2, 2};
    }

    public DatLoader(InputStream stream) {
        this(stream, null);
    }

    public DatLoader(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DatLoaderTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DatLoader(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DatLoaderTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DatLoader(DatLoaderTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(DatLoaderTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[3];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 4; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 3; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        DatLoader.jj_la1_init_0();
    }
}

