/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.CollisionAvoider;
import datastore.Coloring;
import datastore.DataColumn;
import datastore.Datapoint;
import datastore.editor.DataSeries;
import datastore.editor.DataSteward;
import gui.ImageGenerator;
import gui.Language;
import gui.RichText;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.editor.SpreadSheet;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import path.ResPath;
import util.Util;

public class ZoneColumn
extends DataColumn {
    private static final long serialVersionUID = 1L;
    public static int LINE_WIDTH = 1;
    public static String LINE_STYLE = "stroke-width: 1; stroke: black;";
    public static String LINE_STYLE_FOR_INTERVAL_COL = "stroke-width: 0; stroke: none;";
    public static int DEFAULT_CRUNCH_OUTER_MARGIN = 5;
    public static int DEFAULT_CRUNCH_INNER_MARGIN = 1;
    public static int DEFAULT_CRUNCH_ASCEND_WIDTH = 4;
    public static int DEFAULT_CRUNCH_ONE_SIDE_SPACE_USE = DEFAULT_CRUNCH_OUTER_MARGIN + DEFAULT_CRUNCH_ASCEND_WIDTH + DEFAULT_CRUNCH_INNER_MARGIN;
    public static int SMALLER_CRUNCH_OUTER_MARGIN = 0;
    public static int SMALLER_CRUNCH_INNER_MARGIN = 1;
    public static int SMALLER_CRUNCH_ASCEND_WIDTH = 3;
    public static int SMALLER_CRUNCH_ONE_SIDE_SPACE_USE = SMALLER_CRUNCH_OUTER_MARGIN + SMALLER_CRUNCH_INNER_MARGIN + SMALLER_CRUNCH_ASCEND_WIDTH;
    public int crunchOuterMargin = DEFAULT_CRUNCH_OUTER_MARGIN;
    public int crunchInnerMargin = DEFAULT_CRUNCH_INNER_MARGIN;
    public int crunchAscendWidth = DEFAULT_CRUNCH_ASCEND_WIDTH;
    public int crunchOneSideSpaceUse = DEFAULT_CRUNCH_ONE_SIDE_SPACE_USE;
    public int orientation;
    public boolean autoFlip = false;
    public boolean disableZoneLabelAutoScaling = false;
    public boolean BLOCK_PRIORITY_SET = false;

    @Override
    public void addData(Datapoint dp) {
        if (!(dp instanceof ZCDatapoint)) {
            ZCDatapoint zcd = new ZCDatapoint(dp);
            dp = zcd;
        }
        super.addData(dp);
    }

    public ZoneColumn(String colName) {
        super(colName);
        this.iconPath = ResPath.getPath("icons.col_icon_block");
        this.orientation = 1;
        if (this.name.compareToIgnoreCase("Sub-Era") == 0) {
            this.maxChronostratLevel = 3;
        } else if (this.name.compareToIgnoreCase("Sub-Period") == 0) {
            this.maxChronostratLevel = 5;
        }
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 3));
            final ZoneColumn thisZC = this;
            final JCheckBox priorityCB = new JCheckBox(Language.translate("Enable Priority", true));
            final JRadioButton rNormal = new JRadioButton(Language.translate("Horizontal", true));
            final JRadioButton rVertical = new JRadioButton(Language.translate("Vertical", true));
            ButtonGroup orientGroup = new ButtonGroup();
            orientGroup.add(rNormal);
            orientGroup.add(rVertical);
            final JCheckBox bAutoFlip = new JCheckBox(Language.translate("Auto Flip Label", true));
            final JCheckBox disableZoneLabelAutoScaling = new JCheckBox(Language.translate("Disable Label Scaling", false));
            ItemListener il = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    Object source = ie.getSource();
                    if (source == bAutoFlip) {
                        thisZC.autoFlip = bAutoFlip.isSelected();
                    } else if (source == disableZoneLabelAutoScaling) {
                        thisZC.disableZoneLabelAutoScaling = disableZoneLabelAutoScaling.isSelected();
                    } else if (source == rNormal || source == rVertical) {
                        if (rVertical.isSelected()) {
                            thisZC.setOrientation(4);
                        } else {
                            thisZC.setOrientation(1);
                        }
                    } else if (source == priorityCB) {
                        ZoneColumn.this.BLOCK_PRIORITY_SET = priorityCB.isSelected();
                    }
                }
            };
            priorityCB.addItemListener(il);
            bAutoFlip.addItemListener(il);
            disableZoneLabelAutoScaling.addItemListener(il);
            rNormal.addItemListener(il);
            rVertical.addItemListener(il);
            bAutoFlip.setSelected(this.autoFlip);
            if (this.getOrientation() == 4) {
                rVertical.setSelected(true);
            } else {
                rNormal.setSelected(true);
            }
            this.optionsPanel.add(priorityCB);
            this.optionsPanel.add(disableZoneLabelAutoScaling);
            this.optionsPanel.add(new JLabel(Language.translate("Labels:", true)));
            this.optionsPanel.add(rNormal);
            this.optionsPanel.add(rVertical);
            this.optionsPanel.add(bAutoFlip);
        }
        return this.optionsPanel;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public SortedSet negateAges() {
        return this.negateAgesBreakerBased();
    }

    @Override
    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        super.grayOutIfEmpty(topAge, baseAge, en);
        if (!(this.name.equalsIgnoreCase("Facies Label") || this.name.equalsIgnoreCase("Series Label") || this.name.equalsIgnoreCase("Members"))) {
            return this.grayedOut;
        }
        Iterator iter = this.getDrawingData();
        Iterator iter1 = this.getDrawingData();
        double curTop = topAge;
        double curBase = baseAge;
        Datapoint p1 = null;
        int dis1 = 0;
        int dis2 = 0;
        int dis3 = 0;
        int count = 0;
        boolean count_final = false;
        boolean lastGO = this.grayedOut;
        if (this.isOutcrop) {
            double outBase = 0.0;
            double outPrev = 0.0;
            if (curTop < curBase) {
                return this.grayedOut;
            }
            while (iter1.hasNext() && !(curTop + 1.0E-6 <= curBase)) {
                Datapoint p = (Datapoint)iter1.next();
                outBase = -p.baseAge;
                if (outBase <= curTop && outBase >= curBase) {
                    ++count;
                }
                if (p1 != null) {
                    outPrev = -p1.baseAge;
                    dis1 = Math.abs((int)(outBase - curBase));
                    dis2 = Math.abs((int)(outBase - curTop));
                    dis3 = Math.abs((int)(outBase - outPrev));
                    if (dis3 >= dis2 && curBase >= outBase && p.value.toString().equals("TOP")) {
                        count = 0;
                    }
                    if (dis3 >= dis2 && curBase >= outBase && !p.value.toString().equals("TOP")) {
                        count = 1;
                    }
                }
                p1 = p;
                if (count == 0) continue;
                count_final = true;
            }
        } else {
            while (iter1.hasNext() && !(curTop + 1.0E-6 >= curBase)) {
                Datapoint p = (Datapoint)iter1.next();
                if (p.baseAge <= curBase && p.baseAge >= curTop) {
                    ++count;
                }
                if (p1 != null) {
                    dis1 = Math.abs((int)(p.baseAge - curBase));
                    dis2 = Math.abs((int)(p.baseAge - curTop));
                    dis3 = Math.abs((int)(p.baseAge - p1.baseAge));
                    if (dis3 >= dis2 && curBase <= p.baseAge && p.value.toString().equals("TOP")) {
                        count = 0;
                    }
                    if (dis3 >= dis2 && curBase <= p.baseAge && !p.value.toString().equals("TOP")) {
                        count = 1;
                    }
                }
                p1 = p;
                if (count == 0) continue;
                count_final = true;
            }
        }
        if (count == 0) {
            this.NoDataInDataColumn = true;
            this.grayedOut = true;
        } else {
            this.NoDataInDataColumn = false;
            this.grayedOut = false;
        }
        return this.grayedOut;
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        CollisionAvoider.Node[] ageN;
        ZCDatapoint p;
        super.drawData(ig, startx, starty, width, height, settings);
        if (this.myWidth - (double)(this.crunchOneSideSpaceUse * 2) < 30.0) {
            this.crunchOuterMargin = SMALLER_CRUNCH_OUTER_MARGIN;
            this.crunchInnerMargin = SMALLER_CRUNCH_INNER_MARGIN;
            this.crunchAscendWidth = SMALLER_CRUNCH_ASCEND_WIDTH;
            this.crunchOneSideSpaceUse = SMALLER_CRUNCH_ONE_SIDE_SPACE_USE;
        }
        Iterator iter = this.getDrawingData();
        double topAge = settings.topAge;
        double pointTopAge = 0.0;
        double baseAge = settings.baseAge;
        double largestBaseSoFar = -9.9999999E7;
        double unitToAgeFactor = height / (settings.baseAge - settings.topAge);
        double ageLabelHeight = 0.0;
        if (this.drawAgeLabel) {
            FontMetrics fm = ig.getFontMetrics(this.fonts.getFont(1));
            ageLabelHeight = fm.getAscent();
        }
        CollisionAvoider ca = new CollisionAvoider(0.0, height, LINE_WIDTH, width, width - (double)(2 * this.crunchOneSideSpaceUse));
        ca.setAllowFlip(this.autoFlip);
        while (iter.hasNext() && !settings.isBelow(largestBaseSoFar)) {
            p = (ZCDatapoint)iter.next();
            if (settings.isAbove(p.baseAge)) {
                pointTopAge = p.baseAge;
                continue;
            }
            largestBaseSoFar = p.baseAge;
            baseAge = Math.min(p.baseAge, settings.baseAge);
            String pLabel = p.label;
            if (p.breaker) {
                pLabel = "";
            }
            if (this.disableZoneLabelAutoScaling) {
                ca.disableZoneLabelAutoScaling = true;
            }
            ca.add(p, unitToAgeFactor * (topAge - settings.topAge), unitToAgeFactor * (baseAge - settings.topAge), pointTopAge, p.baseAge, ig.getSWI(new RichText(pLabel, this.fileInfo), this.fonts.getFont(3), this.orientation), ageLabelHeight);
            topAge = baseAge;
            pointTopAge = baseAge;
        }
        if (!settings.isBelow(largestBaseSoFar)) {
            p = new ZCDatapoint();
            p.baseAge = settings.baseAge;
            p.breaker = true;
            ca.add(p, unitToAgeFactor * (largestBaseSoFar - settings.topAge), unitToAgeFactor * (settings.baseAge - settings.topAge), pointTopAge, p.baseAge, ig.getSWI(new RichText(p.label, this.fileInfo), this.fonts.getFont(3), this.orientation));
        }
        if (this.BLOCK_PRIORITY_SET || settings.enPriority) {
            ageN = new CollisionAvoider.Node[ca.getNumNodes()];
            Vector<CollisionAvoider.Node> skippedNodes = new Vector<CollisionAvoider.Node>();
            Collections.sort(ca.nodeVector, new CollisionAvoider.Node());
            ca.nodeVector.toArray(ageN);
            double currBase = 0.0;
            for (int i = 0; i < ageN.length; ++i) {
                ca.nodeVector.remove(ageN[i]);
                String mergedLabel = ageN[i].dp.label;
                if (skippedNodes != null && skippedNodes.size() > 0) {
                    mergedLabel = ((CollisionAvoider.Node)skippedNodes.get((int)0)).dp.label + "  -  " + ageN[i].dp.label;
                }
                StringWrappingInfo currSWI = ig.getSWI(new RichText(mergedLabel, this.fileInfo), this.fonts.getFont(3), this.orientation);
                currSWI.wrap(width);
                double ageHeight = this.fonts.getFont(1).getSize();
                double uncertaintyHeight = this.fonts.getFont(1).getSize();
                double spaceAvailable = currSWI.getFontHeight() * (double)currSWI.getNumLines();
                if (this.drawAgeLabel && !this.drawUncertaintyLabel) {
                    spaceAvailable += ageHeight;
                } else if (!this.drawAgeLabel && this.drawUncertaintyLabel) {
                    spaceAvailable += uncertaintyHeight;
                } else if (this.drawAgeLabel && this.drawUncertaintyLabel) {
                    spaceAvailable += Math.max(ageHeight, uncertaintyHeight);
                }
                if (ageN[i].origBase - currBase < spaceAvailable && ageN[i].dp.priority < 2 && ageN[i].dp.label.compareToIgnoreCase("TOP") != 0) {
                    skippedNodes.add(ageN[i]);
                    if (i > 0 && ageN[i].dp.priority != 1 && ageN[i - 1].dp.priority < 2 || i < ageN.length - 1 && ageN[i + 1].dp.priority < 2) continue;
                }
                ageN[i].swi = currSWI;
                ageN[i].mergedNodes = new Vector();
                ageN[i].mergedNodes.addAll(skippedNodes);
                skippedNodes.removeAllElements();
                currBase = ageN[i].origBase;
                try {
                    if (ageN[i].dp.label.compareToIgnoreCase("TOP") == 0) continue;
                    ca.nodeVector.add(ageN[i]);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        } else if (settings.enHideBlockLable) {
            ageN = new CollisionAvoider.Node[ca.getNumNodes()];
            Collections.sort(ca.nodeVector, new CollisionAvoider.Node());
            ca.nodeVector.toArray(ageN);
            double currBase = 0.0;
            for (int i = 0; i < ageN.length; ++i) {
                ca.nodeVector.remove(ageN[i]);
                String currLabel = ageN[i].dp.label;
                StringWrappingInfo currSWI = ig.getSWI(new RichText(currLabel, this.fileInfo), this.fonts.getFont(3), this.orientation);
                currSWI.wrap(width);
                double ageHeight = this.fonts.getFont(1).getSize();
                double uncertaintyHeight = this.fonts.getFont(1).getSize();
                double spaceAvailable = currSWI.getFontHeight() * (double)currSWI.getNumLines();
                if (this.drawAgeLabel && !this.drawUncertaintyLabel) {
                    spaceAvailable += ageHeight;
                } else if (!this.drawAgeLabel && this.drawUncertaintyLabel) {
                    spaceAvailable += uncertaintyHeight;
                } else if (this.drawAgeLabel && this.drawUncertaintyLabel) {
                    spaceAvailable += Math.max(ageHeight, uncertaintyHeight);
                }
                if (ageN[i].origBase - currBase < spaceAvailable && ageN[i].dp.priority < 2 && ageN[i].dp.label.compareToIgnoreCase("TOP") != 0) {
                    currLabel = "";
                }
                ageN[i].swi = currSWI = ig.getSWI(new RichText(currLabel, this.fileInfo), this.fonts.getFont(3), this.orientation);
                currBase = ageN[i].origBase;
                try {
                    if (ageN[i].dp.label.compareToIgnoreCase("TOP") == 0) continue;
                    ca.nodeVector.add(ageN[i]);
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        ca.pack();
        this.drawItems(ig, startx, starty, width, height, settings, ca, 0, ca.getNumNodes() - 1, ageLabelHeight);
        this.drawOverlays(ig, startx, starty, width, height, settings);
    }

    public void drawItems(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider ca, int first, int last, double ageLabelHeight) {
        if (last < first) {
            return;
        }
        for (int cur = last; cur >= first; --cur) {
            CollisionAvoider.Node node = ca.getAt(cur);
            this.drawItem(ig, startx, starty, width, height, settings, node, ageLabelHeight);
        }
    }

    protected void drawItem(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings, CollisionAvoider.Node node, double ageLabelHeight) {
        Color c = null;
        ZCDatapoint p = (ZCDatapoint)node.dp;
        double[] tabX = new double[12];
        double[] tabY = new double[12];
        double[] baselineX = new double[6];
        double[] baselineY = new double[6];
        String fillStyle = "stroke-width: 0; fill: none;";
        if (this.color != null && !p.breaker || p.color != null) {
            c = p.color;
            if (c == null && this.color.useNamed) {
                if (p != null) {
                    c = this.color.getColor(p.label);
                }
                if (c == null && p != null) {
                    c = this.color.getColor(p.popup);
                }
            }
            if (c == null) {
                c = this.color.getColor(node.origTopAge, node.origBaseAge);
            }
            if (c != null) {
                fillStyle = Coloring.getStyle(c);
            }
        }
        tabX[0] = tabX[11] = startx;
        tabX[1] = tabX[10] = startx + (double)this.crunchOuterMargin;
        tabX[2] = tabX[9] = startx + (double)this.crunchOuterMargin + (double)this.crunchAscendWidth;
        tabX[3] = tabX[8] = startx + width - (double)(this.crunchOuterMargin + this.crunchAscendWidth);
        tabX[4] = tabX[7] = startx + width - (double)this.crunchOuterMargin;
        tabX[5] = tabX[6] = startx + width;
        tabY[4] = tabY[5] = Math.max(starty + node.origTop, starty);
        tabY[1] = tabY[5];
        tabY[0] = tabY[5];
        if ((this.BLOCK_PRIORITY_SET || settings.enPriority) && node.mergedNodes != null && node.mergedNodes.size() > 0) {
            tabY[4] = tabY[5] = Math.max(starty + node.mergedNodes.get((int)0).origTop, starty);
            tabY[1] = tabY[5];
            tabY[0] = tabY[5];
        }
        tabY[2] = tabY[3] = starty + node.calcTop;
        tabY[9] = tabY[8] = starty + node.calcBase;
        tabY[7] = tabY[6] = Math.min(starty + node.origBase, starty + height);
        tabY[10] = tabY[6];
        tabY[11] = tabY[6];
        ig.drawPolygon(tabX, tabY, (isIntervalCol ? LINE_STYLE_FOR_INTERVAL_COL : LINE_STYLE) + fillStyle);
        if (!settings.isBelow(node.origBaseAge)) {
            if (p.lineType == 4 && p.value == null) {
                Vector<Double> X = new Vector<Double>();
                Vector<Double> Y = new Vector<Double>();
                double y = tabY[11];
                for (double i = 0.0; i < width; i += 0.5235987755982988) {
                    X.add(new Double(startx + i));
                    Y.add(new Double(y + 3.0 * Math.sin(i)));
                }
                double[] xs = Util.getDoubleArray(X);
                double[] ys = Util.getDoubleArray(Y);
                ig.drawPolyline(xs, ys, (isIntervalCol ? LINE_STYLE_FOR_INTERVAL_COL : LINE_STYLE) + "fill:none; " + Settings.getStroke(p == null ? 1 : p.lineType));
            } else {
                baselineX[0] = tabX[11];
                baselineX[1] = tabX[10];
                baselineX[2] = tabX[9];
                baselineX[3] = tabX[8];
                baselineX[4] = tabX[7];
                baselineX[5] = tabX[6];
                baselineY[4] = baselineY[5] = tabY[11];
                baselineY[1] = baselineY[5];
                baselineY[0] = baselineY[5];
                baselineY[2] = baselineY[3] = tabY[9];
                ig.drawPolyline(baselineX, baselineY, (isIntervalCol ? LINE_STYLE_FOR_INTERVAL_COL : LINE_STYLE) + "fill:none; " + Settings.getStroke(p == null ? 1 : p.lineType));
            }
        }
        if (isIntervalCol) {
            return;
        }
        if (node.dp == null || !node.dp.breaker) {
            double sx = startx + (double)this.crunchOneSideSpaceUse;
            double wx = width - (double)(2 * this.crunchOneSideSpaceUse);
            if (node.calcBase <= node.origBase && node.calcTop >= node.origTop) {
                sx = startx;
                wx = width;
                node.swi.rewrap(width);
            }
            ig.drawString(node.swi, sx, node.calcTop + starty, wx, node.getCalcHeight() - ageLabelHeight, 2, node.calcTop + starty, 10, c);
            StringWrappingInfo ageLabel = ig.getSWIOneLine(this.getAgeLabel(node.origBaseAge, node.dp.isAgeInteger), this.fonts.getFont(1), 1, this.fileInfo);
            StringWrappingInfo uncertaintyLabel = ig.getSWIOneLine(this.getUncertaintyLabel(node), this.fonts.getFont(2), 1, this.fileInfo);
            if (this.drawAgeLabel) {
                ig.drawString(ageLabel, sx + 10.0, node.calcTop + starty, 20.0, node.getCalcHeight() - (double)LINE_WIDTH, 3, node.calcTop + starty, 10, c);
            }
            if (this.drawUncertaintyLabel) {
                ig.drawString(uncertaintyLabel, sx + ageLabel.getWidth() + 5.0 + 10.0, node.calcTop + starty, 20.0, node.getCalcHeight() - (double)LINE_WIDTH, 3, node.calcTop + starty, 10, c);
            }
        }
        if (settings.doPopups) {
            ig.pushGrouping();
            String popupData = "";
            if (this.BLOCK_PRIORITY_SET || settings.enPriority) {
                for (int i = 0; i < node.mergedNodes.size(); ++i) {
                    CollisionAvoider.Node currNode = node.mergedNodes.get(i);
                    popupData = popupData + "<h3><u>" + currNode.dp.label + " ( Age: " + currNode.dp.baseAge + " )</u></h3>" + (node.mergedNodes.get((int)i).dp.popup == null ? " " : node.mergedNodes.get((int)i).dp.popup) + "<br/><br/><HR NOSHADE> ";
                }
            }
            popupData = p.label != null ? popupData + "<h3><u>" + p.label + " ( Age: " + p.baseAge + " ) </u></h3>" + (p.popup == null ? " " : p.popup) + "<br/><br/><HR NOSHADE> " : popupData + "<h3><u>( Age: " + p.baseAge + " ) </u></h3>" + (p.popup == null ? " " : p.popup) + "<br/><br/><HR NOSHADE> ";
            ig.doPopupThings(popupData, this.fileInfo);
            ig.drawPolygon(tabX, tabY, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
    }

    @Override
    public void readOneSetting(Element setting, Settings settings) {
        super.readOneSetting(setting, settings);
        String name = setting.getAttribute("name");
        if (name != null) {
            if (name.compareToIgnoreCase("orientation") == 0) {
                String orient = setting.getAttribute("orientation");
                this.orientation = orient.compareToIgnoreCase("vertical") == 0 ? 4 : 1;
            } else if (name.compareToIgnoreCase("autoFlip") == 0) {
                this.autoFlip = Boolean.valueOf(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchOuterMargin") == 0) {
                this.crunchOuterMargin = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchInnerMargin") == 0) {
                this.crunchInnerMargin = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchAscendWidth") == 0) {
                this.crunchAscendWidth = Integer.parseInt(Settings.getNodeTextContent(setting));
            } else if (name.compareToIgnoreCase("crunchOneSideSpaceUse") == 0) {
                this.crunchOneSideSpaceUse = Integer.parseInt(Settings.getNodeTextContent(setting));
            }
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        element.appendChild(Settings.createSimpleSetting(doc, "crunchOuterMargin", "" + this.crunchOuterMargin));
        element.appendChild(Settings.createSimpleSetting(doc, "crunchInnerMargin", "" + this.crunchInnerMargin));
        element.appendChild(Settings.createSimpleSetting(doc, "crunchAscendWidth", "" + this.crunchAscendWidth));
        element.appendChild(Settings.createSimpleSetting(doc, "crunchOneSideSpaceUse", "" + this.crunchOneSideSpaceUse));
        element.appendChild(Settings.createSimpleSetting(doc, "autoFlip", "" + this.autoFlip));
        Element orientE = Settings.createSimpleSetting(doc, "orientation", "");
        if (this.orientation == 4) {
            orientE.setAttribute("orientation", "vertical");
        } else {
            orientE.setAttribute("orientation", "normal");
        }
        element.appendChild(orientE);
    }

    @Override
    public void write(Writer w) throws IOException {
        this.writeHeader(w, "block");
        Iterator iter = this.getData();
        while (iter.hasNext()) {
            ZCDatapoint dp = (ZCDatapoint)iter.next();
            if (dp.breaker) {
                w.write("\tTOP\t" + Double.toString(dp.baseAge) + "\t\r\n");
                continue;
            }
            String label = dp.label;
            if (label == null || label.length() < 1) {
                label = " ";
            }
            w.write("\t" + label + "\t" + Double.toString(dp.baseAge) + "\t");
            switch (dp.lineType) {
                case 2: {
                    w.write("dashed\t");
                    break;
                }
                case 3: {
                    w.write("dotted\t");
                    break;
                }
                case 1: {
                    w.write("solid\t");
                    break;
                }
                default: {
                    w.write(9);
                }
            }
            if (dp.popup != null) {
                ZoneColumn.writeRichText(w, dp.popup);
            }
            w.write("\r\n");
        }
        this.writeOverlaysAndUnderlays(w);
    }

    @Override
    public DataSeries getSeriesModel(int which) {
        if (which != 0) {
            return null;
        }
        DataSeries series = new DataSeries();
        series.setSingle(new DataSteward(this.data, new TableInterpreter()));
        return series;
    }

    public class TableInterpreter
    extends DataColumn.TableInterpreter {
        public String[] myNames = new String[]{"Label", "Age", "Line", "Popup"};
        public String[] myToolTips = new String[]{"The text shown at that block, or TOP to specify top", "Base of the block", "Style of line at base of block", "Text of popup window."};
        public Class[] myClasses = new Class[]{String.class, Double.class, DataColumn.TableInterpreter.LineType.class, String.class};

        public TableInterpreter() {
            this.names = this.myNames;
            this.classes = this.myClasses;
            this.toolTips = this.myToolTips;
        }

        @Override
        public void registerEditorsAndRenderers(SpreadSheet spread) {
            spread.setDefaultEditor(DataColumn.TableInterpreter.LineType.class, new DefaultCellEditor(new DataColumn.TableInterpreter.LineType().getComboBox()));
            spread.setDefaultRenderer(DataColumn.TableInterpreter.LineType.class, new DataColumn.TableInterpreter.LineType());
        }

        @Override
        public Object getValue(Datapoint p, int col) {
            switch (col) {
                case 0: {
                    return p.label;
                }
                case 1: {
                    return new Double(p.baseAge);
                }
                case 2: {
                    switch (p.lineType) {
                        case 2: {
                            return "dashed";
                        }
                        case 3: {
                            return "dotted";
                        }
                    }
                    return "";
                }
                case 3: {
                    return p.popup;
                }
            }
            return null;
        }

        @Override
        public void setValue(Datapoint p, Object value, int col) {
            if (value == null) {
                value = "";
            }
            switch (col) {
                case 0: {
                    p.label = value.toString();
                    if (p.label.compareTo("TOP") == 0) {
                        p.breaker = true;
                        break;
                    }
                    p.breaker = false;
                    break;
                }
                case 1: {
                    double age = Double.NaN;
                    if (value instanceof Double) {
                        age = (Double)value;
                    } else {
                        try {
                            age = Double.parseDouble(value.toString());
                        }
                        catch (Exception e) {
                            age = Double.NaN;
                        }
                    }
                    if (!Double.isNaN(age)) {
                        p.baseAge = age;
                        break;
                    }
                    p.baseAge = 0.0;
                    break;
                }
                case 2: {
                    String s = value.toString().trim();
                    if (s.compareToIgnoreCase("dashed") == 0) {
                        p.lineType = 2;
                        break;
                    }
                    if (s.compareToIgnoreCase("dotted") == 0) {
                        p.lineType = 3;
                        break;
                    }
                    p.lineType = 1;
                    break;
                }
                case 3: {
                    p.popup = value.toString();
                }
            }
        }
    }

    public static class ZCDatapoint
    extends Datapoint {
        public Color color = null;

        public ZCDatapoint() {
        }

        public ZCDatapoint(Datapoint dp) {
            super(dp);
        }

        @Override
        public ZCDatapoint copy() {
            ZCDatapoint ret = new ZCDatapoint(this);
            ret.color = this.color;
            return ret;
        }
    }
}

