/*
 * Decompiled with CFR 0.152.
 */
package datastore;

import datastore.ChronColumn;
import datastore.DataColumn;
import datastore.DataColumnChangeEvent;
import datastore.DataColumnChangeListener;
import datastore.Datapoint;
import datastore.Datastore;
import datastore.EventColumn;
import datastore.PointColumn;
import datastore.RangeColumn;
import datastore.RootColumn;
import datastore.RulerColumn;
import datastore.Unit;
import datastore.ages.AgeConverter;
import gui.FontManager;
import gui.FontOptions;
import gui.ImageGenerator;
import gui.Language;
import gui.LinkProcessor;
import gui.Settings;
import gui.StringWrappingInfo;
import gui.TSCFont;
import gui.TSCreator;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import path.ResPath;

public class MetaColumn
extends DataColumn
implements DataColumnChangeListener {
    private static final long serialVersionUID = 1L;
    public static final int FOOTER_MARGIN = 30;
    public static final int FOOTER_GAP = 20;
    public static final int ADDED = 1;
    public static final int REPLACED = 2;
    public static final int DIDNOTHING = 3;
    public static final int CLAIMED = 4;
    public static final double HEADER_BORDER_WIDTH = Settings.BORDER_WIDTH;
    public static final double COLUMN_BORDER_WIDTH = Settings.BORDER_WIDTH;
    public static final String FOOTER_STYLE = "stroke-width: 2; stroke: black; fill : white; ";
    public static final String HEADER_BORDER_STYLE = "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ";
    public static final String COLUMN_BORDER_STYLE = "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ";
    protected SubColumnListModel subColListModel = new SubColumnListModel();
    public boolean replaceDupes = true;
    public double FOOTER_HEIGHT = 0.0;
    public double COL_NAME_WIDTH = 0.0;
    public static int flamer = 0;
    public Vector<footer> footerList;
    public Vector<DataColumn> derp;
    public Vector<DataColumn> tilly;
    public Vector<DataColumn> subColumns = new Vector<DataColumn>(){
        private static final long serialVersionUID = 1L;

        @Override
        public void add(int i, DataColumn o) {
            super.add(i, o);
            MetaColumn.this.subColListModel.fireColumnsAdded(i, i);
            o.addChangeListener(MetaColumn.this);
        }

        @Override
        public synchronized boolean add(DataColumn o) {
            super.add(o);
            MetaColumn.this.subColListModel.fireColumnsAdded(this.size() - 1, this.size() - 1);
            o.addChangeListener(MetaColumn.this);
            return true;
        }

        @Override
        public synchronized DataColumn remove(int i) {
            DataColumn ret = (DataColumn)super.remove(i);
            MetaColumn.this.subColListModel.fireColumnsRemoved(i, i);
            ret.removeChangeListener(MetaColumn.this);
            return ret;
        }

        public boolean remove(DataColumn o) {
            int i = this.indexOf(o);
            if (super.remove(o)) {
                MetaColumn.this.subColListModel.fireColumnsRemoved(i, i);
                o.removeChangeListener(MetaColumn.this);
                return true;
            }
            return false;
        }
    };

    public MetaColumn(String colName) {
        this(colName, false);
    }

    public MetaColumn(String colName, boolean ph) {
        super(colName, ph);
        this.iconPath = ResPath.getPath("icons.col_icon_group");
        this.setAllowsChildren(true);
    }

    public ListModel getSubColumnListModel() {
        return this.subColListModel;
    }

    @Override
    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            final MetaColumn thisMC = this;
            JButton addCol = new JButton(Language.translate("Add Blank Column", true));
            addCol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    thisMC.addColumn(new DataColumn(MetaColumn.this.getNewColumnName("Blank")));
                }
            });
            JButton addRuler = new JButton(Language.translate("Add Age Column", true));
            addRuler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    thisMC.addColumn(new RulerColumn("Age", true));
                }
            });
            this.optionsPanel.add(addCol);
            this.optionsPanel.add(addRuler);
        }
        return this.optionsPanel;
    }

    public int associate(String metaName, String newColName, boolean defaultHandler) {
        MetaColumn mc;
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int ret = 3;
        while (iter.hasNext()) {
            int recurRec;
            DataColumn dc = iter.next();
            if (!(dc instanceof MetaColumn) || (recurRec = (mc = (MetaColumn)dc).associate(metaName, newColName, false)) != 4) continue;
            ret = 4;
        }
        if (this.name.compareToIgnoreCase(metaName) == 0) {
            if (!this.replaceDupes || this.getColumnByName(newColName) == null) {
                this.subColumns.add(new MetaColumn(newColName, true));
            }
            ret = 4;
        }
        if (ret != 4 && defaultHandler) {
            mc = new MetaColumn(metaName, true);
            this.subColumns.add(mc);
            ret = mc.associate(metaName, newColName, false);
        }
        return ret;
    }

    public int addColumn(DataColumn newCol, boolean addNotClaimed) {
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int ret = 3;
        boolean needToAdd = false;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            if (dc.name.compareToIgnoreCase(newCol.name) == 0) {
                if (this.replaceDupes || dc.placeHolder) {
                    flamer = dc.myNum;
                    this.subColumns.remove(dc);
                }
                needToAdd = true;
                if (this.replaceDupes || !dc.placeHolder) {
                    ret = 2;
                    break;
                }
                if (ret != 3) break;
                ret = 1;
                break;
            }
            if (!(dc instanceof MetaColumn)) continue;
            MetaColumn mc = (MetaColumn)dc;
            int recurRet = mc.addColumn(newCol, false);
            if (recurRet == 2) {
                ret = 2;
                continue;
            }
            if (recurRet != 1 || ret == 2) continue;
            ret = 1;
        }
        if (needToAdd || addNotClaimed && ret == 3) {
            newCol.myNum = flamer;
            this.addColumn(newCol);
        }
        return ret;
    }

    public void addColumn(DataColumn newCol) {
        this.subColumns.add(newCol);
        super.add(newCol);
        newCol.fonts.setParent(this.fonts);
        newCol.setDS(this.ds);
        if (this.unit != null && !(newCol instanceof RootColumn) && newCol.unit == null) {
            newCol.setUnit(this.unit);
        }
        this.fireChange(1, this.subColumns.size() - 1, this.subColumns.size() - 1);
    }

    public void insertColumn(DataColumn newCol, int where) {
        if (where < 0) {
            where = 0;
        }
        if (where > this.subColumns.size()) {
            where = this.subColumns.size();
        }
        this.subColumns.insertElementAt(newCol, where);
        super.add(newCol);
        newCol.fonts.setParent(this.fonts);
        newCol.setDS(this.ds);
        this.fireChange(1, where, where);
    }

    public void goThroughStuff() {
        this.doStuff();
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            if (dc.placeHolder && dc instanceof MetaColumn) {
                MetaColumn mc = (MetaColumn)dc;
                mc.goThroughStuff();
            }
            ++i;
        }
    }

    public void clearPlaceholders() {
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            if (dc.placeHolder) {
                if (dc instanceof MetaColumn) {
                    MetaColumn mc = (MetaColumn)dc;
                    mc.clearPlaceholders();
                    if (mc.subColumns.size() != 0) {
                        mc.stabilizePlaceHolder(this, i);
                    } else {
                        iter.remove();
                        TSCreator.logAndShow("ignoring group column " + dc.getName() + " because it is empty.", 1);
                    }
                } else {
                    iter.remove();
                    TSCreator.logAndShow("ignoring column " + dc.getName() + " because it is a placeholder but not a grouping.", 1);
                }
            }
            ++i;
        }
    }

    protected void stabilizePlaceHolder(MetaColumn parent, int treeIndex) {
        this.placeHolder = false;
        if (treeIndex > parent.getChildCount()) {
            TSCreator.logAndShow("stabilizePlaceHolder(): " + this.getName() + " treeIndex (" + treeIndex + ") too high. (childCount=" + parent.getChildCount() + ")", 1);
            treeIndex = parent.getChildCount();
        }
        parent.insert(this, treeIndex);
        parent.fireChange(1, treeIndex, treeIndex);
        this.fonts.setParent(parent.fonts);
        this.setDS(parent.ds);
    }

    public DataColumn getColumnByName(String searchName) {
        Iterator<DataColumn> iter = this.subColumns.iterator();
        if (this.name.compareTo(searchName) == 0) {
            return this;
        }
        while (iter.hasNext()) {
            MetaColumn mc;
            DataColumn recurRet;
            DataColumn dc = iter.next();
            if (dc.name.compareTo(searchName) == 0) {
                return dc;
            }
            if (!(dc instanceof MetaColumn) || (recurRet = (mc = (MetaColumn)dc).getColumnByName(searchName)) == null) continue;
            return recurRet;
        }
        return null;
    }

    public DataColumn getColumnByID(String searchID, boolean recurse, boolean onlyNotLoaded) {
        for (DataColumn dc : this.subColumns) {
            MetaColumn mc;
            DataColumn recurRet;
            if ((onlyNotLoaded && !dc.isLoaded || !onlyNotLoaded) && dc.id.compareTo(searchID) == 0) {
                return dc;
            }
            if (!(dc instanceof MetaColumn) || !recurse || (recurRet = (mc = (MetaColumn)dc).getColumnByID(searchID, recurse, onlyNotLoaded)) == null) continue;
            return recurRet;
        }
        return null;
    }

    public Iterator<DataColumn> getSubColumns() {
        return this.subColumns.iterator();
    }

    public DataColumn getColumnByIndex(int i) {
        return this.subColumns.get(i);
    }

    public int getSubColumnCount() {
        return this.subColumns.size();
    }

    public String getNewColumnName(String prefix) {
        prefix = prefix + " ";
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int biggest = 1;
        while (iter.hasNext()) {
            int colNum;
            DataColumn col = iter.next();
            String name = col.getName();
            if (name.length() < prefix.length() || name.substring(0, prefix.length()).compareToIgnoreCase(prefix) != 0) continue;
            String number = "";
            String sub = name.substring(prefix.length());
            for (int i = 0; i < sub.length(); ++i) {
                if (!Character.isDigit(sub.charAt(i))) continue;
                number = number + sub.charAt(i);
            }
            if (number.length() <= 0 || (colNum = Integer.parseInt(number)) < biggest) continue;
            biggest = colNum + 1;
        }
        return prefix + biggest;
    }

    public void moveColumn(DataColumn col, int howFar) {
        int newI;
        int curI = this.subColumns.indexOf(col);
        if (curI < 0) {
            return;
        }
        for (newI = (curI + howFar) % this.subColumns.size(); newI < 0; newI += this.subColumns.size()) {
        }
        if (curI == newI) {
            return;
        }
        col.removeFromParent();
        if (newI == this.subColumns.size() - 1) {
            this.add(col);
        } else {
            this.insert(col, newI);
        }
        DataColumn c = this.subColumns.remove(curI);
        this.subColumns.add(newI, c);
        this.fireChange(3, curI, newI);
    }

    public void removeColumn(DataColumn col) {
        int i = this.subColumns.indexOf(col);
        if (!this.subColumns.remove(col)) {
            return;
        }
        this.fireChange(2, i, i);
    }

    public DataColumn removeColumn(int i) {
        DataColumn c = this.subColumns.remove(i);
        this.fireChange(2, i, i);
        return c;
    }

    @Override
    public void DataColumnChanged(DataColumnChangeEvent evt) {
        switch (evt.getType()) {
            case 3: {
                this.subColListModel.fireColumnChanged(evt.getSource());
            }
        }
    }

    public void fireChange(int structType, int from, int to) {
        DataColumnChangeEvent evt = new DataColumnChangeEvent(this, 2, structType, from, to);
        this.fireChange(evt);
    }

    @Override
    public void setParentFontManager(FontManager parentFM) {
        this.fonts.setParent(parentFM);
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            dc.setParentFontManager(this.fonts);
            ++i;
        }
    }

    @Override
    public void setDS(Datastore ds) {
        super.setDS(ds);
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            dc.setDS(ds);
            ++i;
        }
    }

    @Override
    public void convertAges(AgeConverter translator) {
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            dc.convertAges(translator);
            ++i;
        }
        this.updateMinMaxAges();
    }

    @Override
    public double getDataDensity() {
        Iterator<DataColumn> iter = this.subColumns.iterator();
        double ret = 0.0;
        int i = 0;
        while (iter.hasNext()) {
            double density;
            DataColumn dc = iter.next();
            if (dc.shouldDraw() && !Double.isInfinite(density = dc.getDataDensity())) {
                ret = Math.max(ret, density);
            }
            ++i;
        }
        return ret;
    }

    public void setUnitRecurse(Unit u) {
        super.setUnit(u);
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            if (dc instanceof MetaColumn) {
                ((MetaColumn)dc).setUnitRecurse(u);
            } else {
                dc.setUnit(u);
            }
            ++i;
        }
    }

    @Override
    public void setVariableColoring(Settings s) {
        super.setVariableColoring(s);
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            dc.setVariableColoring(s);
            ++i;
        }
    }

    @Override
    public int[] getRelevantFonts() {
        int[] ret = FontManager.getRelevantFonts(this.getClass());
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            ret = FontManager.uniqueArrayUnion(ret, dc.getRelevantFonts());
            ++i;
        }
        return ret;
    }

    @Override
    public FontOptions getFontOptionsPanel() {
        FontOptions fo = super.getFontOptionsPanel();
        int[] fontsToDo = FontManager.uniqueArraySubtract(this.getRelevantFonts(), FontManager.getRelevantFonts(MetaColumn.class));
        if (fontsToDo.length > 0) {
            JPanel p = fo.addNestedAddPanel();
            p.setBorder(BorderFactory.createTitledBorder("Additional fonts for child columns"));
            fo.addOptions(fontsToDo, true, false);
        }
        return fo;
    }

    @Override
    public double getWidth(Settings settings, ImageGenerator ig, double dataHeight) {
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int ret = 0;
        DataColumn lastSelColumn = null;
        while (iter.hasNext()) {
            DataColumn col = iter.next();
            if (!col.shouldDraw()) continue;
            lastSelColumn = col;
        }
        for (DataColumn col : this.subColumns) {
            if (!col.shouldDraw()) continue;
            ret = (int)((double)ret + col.getWidth(settings, ig, dataHeight));
            if (col == lastSelColumn) continue;
            ret = (int)((double)ret + Settings.BORDER_WIDTH);
        }
        this.myWidth = ret;
        return ret;
    }

    @Override
    public double getHeaderHeight(Settings settings, ImageGenerator ig) {
        Iterator<DataColumn> iter = this.subColumns.iterator();
        double maxSubHeight = 0.0;
        while (iter.hasNext()) {
            DataColumn col = iter.next();
            if (!col.shouldDraw()) continue;
            maxSubHeight = Math.max(maxSubHeight, col.getHeaderHeight(settings, ig));
        }
        for (DataColumn col : this.subColumns) {
            if (!col.shouldDraw()) continue;
            col.setHeaderHeight(maxSubHeight);
        }
        this.nameWrap = ig.wrapString(this.name, this.myWidth, this.fonts.getFont(0), this.fileInfo);
        if (this.name.length() != 0 && this.drawTitle) {
            Rectangle2D textBounds = ig.getStringBounds(this.nameWrap);
            this.myOwnHeaderHeight = textBounds.getHeight();
        } else {
            this.myOwnHeaderHeight = 0.0;
        }
        this.myHeaderHeight = maxSubHeight + this.myOwnHeaderHeight;
        return this.myHeaderHeight;
    }

    @Override
    public void setHeaderHeight(double newHeight) {
        this.myOwnHeaderHeight += newHeight - this.myHeaderHeight;
        this.myHeaderHeight = newHeight;
    }

    public void updatefooterList(TreeNode node, ImageGenerator ig, double width) {
        DataColumn dcol = (DataColumn)node;
        if (node.getChildCount() >= 0 && dcol.shouldDraw()) {
            if (dcol.popup != null && !dcol.popup.isEmpty()) {
                this.footerList.add(new footer(ig, dcol, width));
            }
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.updatefooterList(n, ig, width);
            }
        }
    }

    public void drawFooter(ImageGenerator ig, double startx, double starty, double width, Settings settings) {
        if (!settings.enChartLegend) {
            return;
        }
        this.FOOTER_HEIGHT = 0.0;
        this.footerList = new Vector();
        for (DataColumn col : this.subColumns) {
            this.updatefooterList(col, ig, width);
        }
        if (this.footerList.size() == 0) {
            return;
        }
        StringWrappingInfo heading = ig.wrapString("Selected sources of data for main column sets", width, this.fonts.getFont(11), this.fileInfo);
        this.FOOTER_HEIGHT += heading.getHeight() + 2.0 * heading.getFontHeight();
        ig.drawRect(startx, starty, width, this.FOOTER_HEIGHT, FOOTER_STYLE);
        ig.drawString(heading, startx, starty += heading.getFontHeight(), width, heading.getHeight(), 3);
        Iterator<footer> fIter = this.footerList.iterator();
        starty += heading.getHeight() + heading.getFontHeight();
        while (fIter.hasNext()) {
            footer colData = fIter.next();
            ig.drawString(colData.colName, startx + 30.0, starty, width, colData.maxHeight, 9);
            ig.drawString(colData.colInfo, startx + Math.min(this.COL_NAME_WIDTH, width / 5.0) + 30.0 + 20.0, starty, width, colData.maxHeight, 9);
            starty += colData.maxHeight + colData.maxFontHeight;
        }
    }

    @Override
    public void drawHeader(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        ig.linkProc = this.fileInfo != null ? new LinkProcessor(this.fileInfo) : null;
        Iterator<DataColumn> iter = this.subColumns.iterator();
        if (!(this instanceof RootColumn) && this.name.length() != 0 && this.drawTitle) {
            StringWrappingInfo myWrap = this.nameWrap;
            TSCFont myWrapHolder = this.fonts.getFont(0);
            double eggy = Math.floor(myWrapHolder.getSize());
            double myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
            double myThreshold = this.myWidth * 2.0;
            double eggy2 = eggy;
            String myString = this.name;
            String[] split = myString.split("(\\s)+");
            int myLength = 0;
            AffineTransform affinetransform = new AffineTransform();
            FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
            Font font = new Font("Arial", 0, 14);
            int marker = 0;
            for (int x = 0; x < split.length; ++x) {
                int textwidth = (int)font.getStringBounds(split[x], frc).getWidth();
                if (textwidth <= myLength) continue;
                myLength = textwidth;
                marker = x;
            }
            if (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth()) {
                while (eggy > 6.0 && (myWrap.getNumLines() > 2 || (double)myLength >= this.nameWrap.getWidth())) {
                    myWrapHolder.setSize(eggy);
                    myWrap = ig.wrapString(this.name, this.myWidth, myWrapHolder, this.fileInfo);
                    myLayer = myWrap.getWidth() * (double)myWrap.getNumLines();
                    font = new Font("Arial", 0, (int)eggy);
                    myLength = (int)font.getStringBounds(split[marker], frc).getWidth();
                    eggy -= 1.0;
                }
            }
            ig.drawString(myWrap, startx, starty, width, this.myOwnHeaderHeight, 3);
            eggy = eggy2;
            myWrapHolder.setSize(eggy);
        }
        if (this.popup != null && settings.doPopups) {
            ig.pushGrouping();
            ig.doPopupThings(this.popup, this.fileInfo);
            ig.drawRect(startx, starty, width, this.myOwnHeaderHeight, "stroke-width: 0; opacity: 0.5; fill: red;");
            ig.popGrouping();
        }
        double saveStartx = startx;
        DataColumn lastSelColumn = null;
        while (iter.hasNext()) {
            DataColumn col = iter.next();
            if (!col.shouldDraw()) continue;
            col.drawHeader(ig, startx, starty + this.myOwnHeaderHeight, col.myWidth, height - this.myOwnHeaderHeight, settings);
            startx += col.myWidth;
            startx += Settings.BORDER_WIDTH;
            lastSelColumn = col;
        }
        startx = saveStartx;
        for (DataColumn col : this.subColumns) {
            if (!col.shouldDraw()) continue;
            startx += col.myWidth;
            if (col != lastSelColumn) {
                ig.drawLine(startx + HEADER_BORDER_WIDTH / 2.0, starty + this.myOwnHeaderHeight + col.myHeaderHeight / 2.0, startx + HEADER_BORDER_WIDTH / 2.0, starty + height + HEADER_BORDER_WIDTH / 2.0, "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ");
            }
            startx += Settings.BORDER_WIDTH;
        }
    }

    public void setIsStdChrontoAllChildCols(TreeNode node) {
        DataColumn dcol = (DataColumn)node;
        if (node.getChildCount() >= 0 && dcol.shouldDraw()) {
            dcol.isStdChron = true;
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.setIsStdChrontoAllChildCols(n);
            }
        }
    }

    @Override
    public void drawData(ImageGenerator ig, double startx, double starty, double width, double height, Settings settings) {
        if (this.myWidth < 0.0) {
            this.myWidth = this.getWidth(settings, ig, height);
        }
        if (this.myHeaderHeight < 0.0) {
            this.myHeaderHeight = this.getHeaderHeight(settings, ig);
        }
        DataColumn col2 = null;
        Iterator<DataColumn> iter = this.subColumns.iterator();
        double saveStartx = startx;
        double headerStartx = -1.0;
        double headerStarty = -1.0;
        double headerWidth = -1.0;
        double headerHeight = -1.0;
        DataColumn lastSelColumn = null;
        int insID = -1;
        while (true) {
            int colID = 0;
            iter = this.subColumns.iterator();
            if (insID != -1) {
                while (iter.hasNext()) {
                    col2 = iter.next();
                    if (++colID != insID) continue;
                }
            }
            DataColumn cc = null;
            DataColumn pc = null;
            DataColumn intervalCol = null;
            while (iter.hasNext()) {
                col2 = iter.next();
                if (intervalCol == null && col2.unit != null) {
                    String[] intervalColNames = col2.unit.getIntervalColNames();
                    for (int i = 0; intervalColNames != null && i < intervalColNames.length; ++i) {
                        try {
                            intervalCol = this.ds.getColumnByName(col2.unit, intervalColNames[i]);
                            if (intervalCol == null) continue;
                            break;
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                    }
                }
                if (!col2.shouldDraw()) continue;
                boolean check = false;
                isIntervalCol = false;
                setColBG = false;
                if ((col2 instanceof EventColumn || col2 instanceof RangeColumn) && settings.enEventColBG) {
                    isIntervalCol = true;
                    intervalCol.drawData(ig, startx, starty, col2.myWidth, height, settings);
                    setColBG = true;
                }
                if (col2.getName().equalsIgnoreCase("Standard Chronostratigraphy")) {
                    this.setIsStdChrontoAllChildCols(col2);
                }
                col2.drawData(ig, startx, starty, col2.myWidth, height, settings);
                ++colID;
                startx += col2.myWidth;
                startx += Settings.BORDER_WIDTH;
                lastSelColumn = col2;
                if (col2 instanceof PointColumn && col2.dataMiningColumnDrawing) {
                    PointColumn opc = (PointColumn)col2;
                    PointColumn.PCOptionsPanel opn = (PointColumn.PCOptionsPanel)opc.optionsPanel;
                    if (!opc.dataMiningColumnDrawing || !opn.bFrequency.isSelected() && !opn.bMinimum.isSelected() && !opn.bMaximum.isSelected() && !opn.bAverage.isSelected() && !opn.bRateOfChange.isSelected()) continue;
                    pc = new PointColumn(opc.extraColumnHeaderName);
                    ((PointColumn)pc).data = Collections.synchronizedSortedSet(new TreeSet<Datapoint>(new Datapoint.Comparator()));
                    ((PointColumn)pc).name = opc.extraColumnHeaderName;
                    ((PointColumn)pc).dataMiningColumnDrawing = false;
                    ((PointColumn)pc).drawExtraColumn = false;
                    if (opn.bFrequency.isSelected()) {
                        ((PointColumn)pc).fillColor = new Color(255, 0, 0);
                    } else if (opn.bMinimum.isSelected()) {
                        ((PointColumn)pc).fillColor = new Color(0, 255, 0);
                    } else if (opn.bMaximum.isSelected()) {
                        ((PointColumn)pc).fillColor = new Color(0, 0, 255);
                    } else if (opn.bAverage.isSelected()) {
                        ((PointColumn)pc).fillColor = new Color(0, 200, 255);
                    } else if (opn.bRateOfChange.isSelected()) {
                        ((PointColumn)pc).fillColor = new Color(0, 255, 255);
                    }
                    for (int i = 0; i < opc.newX.length; ++i) {
                        Datapoint dp = new Datapoint();
                        dp.baseAge = opc.newY[i];
                        dp.value = opc.newX[i];
                        if (!(TSCreator.settings.topAge <= dp.baseAge) || !(TSCreator.settings.baseAge >= dp.baseAge)) continue;
                        ((PointColumn)pc).addData(dp);
                    }
                    insID = colID + 1;
                    break;
                }
                if (!(col2 instanceof ChronColumn) || !col2.dataMiningColumnDrawing) continue;
                ChronColumn occ = (ChronColumn)col2;
                check = true;
                cc = new PointColumn(occ.extraColumnHeaderName);
                ((PointColumn)cc).data = Collections.synchronizedSortedSet(new TreeSet<Datapoint>(new Datapoint.Comparator()));
                ((PointColumn)cc).name = occ.extraColumnHeaderName;
                ((PointColumn)cc).dataMiningColumnDrawing = false;
                ((PointColumn)cc).drawExtraColumn = false;
                ((PointColumn)cc).fillColor = new Color(247, 202, 201);
                double[][] polarityChronFrequencyResult = occ.polarityChronFrequencyResult;
                double[] newX = polarityChronFrequencyResult[0];
                double[] newY = polarityChronFrequencyResult[1];
                for (int i = 0; i < newX.length; ++i) {
                    Datapoint dp = new Datapoint();
                    dp.baseAge = newY[i];
                    dp.value = newX[i];
                    if (!(TSCreator.settings.topAge <= dp.baseAge) || !(TSCreator.settings.baseAge >= dp.baseAge)) continue;
                    ((PointColumn)cc).addData(dp);
                }
                insID = colID + 1;
                break;
            }
            if (insID == -1 || col2 == null || pc == null && cc == null) break;
            if (col2 instanceof PointColumn) {
                PointColumn opc = (PointColumn)col2;
                String name = opc.extraColumnHeaderName + " Window " + opc.windowSize + " Myr, Step Size " + opc.stepSize + " Myr";
                pc.setName(name);
            } else if (col2 instanceof ChronColumn) {
                ChronColumn opc = (ChronColumn)col2;
                String name = opc.extraColumnHeaderName + " Window " + opc.windowSize + " Myr, Step Size " + opc.stepSize + " Myr";
                cc.setName(name);
            }
            boolean colExists = false;
            for (DataColumn dc : this.subColumns) {
                String cname = dc.name;
                DataColumn dcc = null;
                if (col2 instanceof PointColumn) {
                    dcc = pc;
                } else if (col2 instanceof ChronColumn) {
                    dcc = cc;
                }
                if (!cname.equalsIgnoreCase(dcc.name)) continue;
                colExists = true;
                break;
            }
            if (!colExists) {
                if (col2 instanceof PointColumn) {
                    ((PointColumn)pc).dataMiningColumnDrawing = false;
                    ((PointColumn)pc).dataMiningColumnDrawing = false;
                    if (((PointColumn)pc).drawScale) {
                        ((PointColumn)pc).drawScale = true;
                    }
                    this.insertColumn(pc, insID);
                } else if (col2 instanceof ChronColumn) {
                    ((PointColumn)cc).dataMiningColumnDrawing = false;
                    ((PointColumn)cc).dataMiningColumnDrawing = false;
                    if (((PointColumn)cc).drawScale) {
                        ((PointColumn)cc).drawScale = true;
                    }
                    this.insertColumn(cc, insID);
                }
            } else {
                pc = null;
                cc = null;
            }
            iter = null;
        }
        startx = saveStartx;
        for (DataColumn col2 : this.subColumns) {
            if (col2.shouldDraw()) {
                startx += col2.myWidth;
                if (col2 != lastSelColumn) {
                    ig.drawLine(startx + COLUMN_BORDER_WIDTH / 2.0, starty - COLUMN_BORDER_WIDTH / 2.0, startx + COLUMN_BORDER_WIDTH / 2.0, starty + height + COLUMN_BORDER_WIDTH / 2.0, "stroke-width: 3; stroke: black; shape-rendering: geometricPrecision; ");
                    startx += Settings.BORDER_WIDTH;
                }
            }
            if (!(col2 instanceof EventColumn)) continue;
            ((EventColumn)col2).cleanupDrawing();
        }
    }

    public void updateMinMaxAgesMetaOnly() {
        for (DataColumn dc : this.subColumns) {
            if (dc instanceof MetaColumn) {
                ((MetaColumn)dc).updateMinMaxAgesMetaOnly();
            }
            this.minAge = Math.min(this.minAge, dc.minAge);
            this.maxAge = Math.max(this.maxAge, dc.maxAge);
        }
    }

    @Override
    public void updateMinMaxAges() {
        for (DataColumn dc : this.subColumns) {
            if (Double.isInfinite(dc.minAge) || !Double.isNaN(dc.minAge)) {
                // empty if block
            }
            this.minAge = Math.min(this.minAge, dc.minAge);
            if (Double.isInfinite(dc.maxAge) || !Double.isNaN(dc.maxAge)) {
                // empty if block
            }
            this.maxAge = Math.max(this.maxAge, dc.maxAge);
        }
    }

    @Override
    public boolean grayOutIfEmpty(double topAge, double baseAge, boolean en) {
        boolean lastGO = this.grayedOut;
        this.grayedOut = !this.isRoot();
        for (DataColumn dc : this.subColumns) {
            if (dc.grayOutIfEmpty(topAge, baseAge, en)) continue;
            this.grayedOut = false;
        }
        if (lastGO != this.grayedOut) {
            this.setName(this.name);
        }
        this.fireChange(3);
        return this.grayedOut;
    }

    @Override
    public boolean shouldDraw() {
        boolean sup = super.shouldDraw();
        if (!sup) {
            return sup;
        }
        for (DataColumn dc : this.subColumns) {
            if (!dc.shouldDraw()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setLoaded(boolean l) {
        this.isLoaded = l;
        for (DataColumn dc : this.subColumns) {
            dc.setLoaded(l);
        }
    }

    @Override
    public void readSettings(Element element, Settings settings) {
        super.readSettings(element, settings);
        NodeList nl = element.getChildNodes();
        int numReadColumns = 0;
        for (int nodeIndex = 0; nodeIndex < nl.getLength(); ++nodeIndex) {
            Node node = nl.item(nodeIndex);
            if (node.getNodeType() != 1 || node.getNodeName().compareToIgnoreCase("column") != 0) continue;
            Element column = (Element)node;
            try {
                String colID = column.getAttribute("id");
                DataColumn loadee = this.getColumnByID(colID, false, true);
                if (loadee == null) {
                    StringTokenizer st = new StringTokenizer(colID, ":");
                    try {
                        String colType = st.nextToken();
                        String colName = st.nextToken();
                        if (colType.compareTo(DataColumn.class.toString()) == 0) {
                            loadee = new DataColumn(colName);
                        } else if (colType.compareTo(RulerColumn.class.toString()) == 0) {
                            loadee = new RulerColumn(colName);
                        }
                        if (loadee != null) {
                            this.addColumn(loadee, true);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                if (loadee == null) continue;
                loadee.readSettings(column, settings);
                loadee.fonts.setParent(this.fonts);
                int curIndex = this.subColumns.indexOf(loadee);
                if (curIndex <= 0) continue;
                this.moveColumn(loadee, numReadColumns - curIndex + 1);
                ++numReadColumns;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeSettings(Element element, Document doc) {
        super.writeSettings(element, doc);
        Iterator<DataColumn> iter = this.subColumns.iterator();
        int i = 0;
        while (iter.hasNext()) {
            DataColumn dc = iter.next();
            Element dcE = doc.createElement("column");
            dc.writeSettings(dcE, doc);
            element.appendChild(dcE);
            ++i;
        }
    }

    @Override
    public void write(Writer w) throws IOException {
        if (!this.isRoot()) {
            w.write(this.getName() + "\t:\t");
            for (DataColumn col : this.subColumns) {
                w.write(col.getName() + "\t");
            }
            if (this.isSelected()) {
                w.write("_METACOLUMN_ON");
            } else {
                w.write("_METACOLUMN_OFF");
            }
            if (this.popup != null) {
                w.write("\t\t");
                MetaColumn.writeRichText(w, this.popup);
            }
            w.write("\r\n\r\n");
        }
        for (DataColumn col : this.subColumns) {
            col.write(w);
            w.write("\r\n\r\n");
        }
    }

    public void doStuff() {
        this.derp = this.subColumns;
        for (int i = 0; i < this.derp.size(); ++i) {
            for (int j = i; j < this.derp.size(); ++j) {
                if (this.derp.get((int)i).myNum <= this.derp.get((int)j).myNum) continue;
                DataColumn alpha = this.derp.get(i);
                DataColumn beta = this.derp.get(j);
                this.derp.set(i, beta);
                this.derp.set(j, alpha);
            }
        }
    }

    public static Vector<DataColumn> mergeSort2(Vector<DataColumn> wheeler) {
        if (wheeler.size() <= 1) {
            return wheeler;
        }
        int middle = wheeler.size() / 2;
        Vector<DataColumn> first = new Vector<DataColumn>();
        Vector<DataColumn> second = new Vector<DataColumn>();
        Vector<DataColumn> result = new Vector<DataColumn>();
        for (int i = 0; i < middle; ++i) {
            first.add(wheeler.get(i));
        }
        for (int j = middle; j < wheeler.size(); ++j) {
            second.add(wheeler.get(j));
        }
        MetaColumn.mergeSort2(first);
        MetaColumn.mergeSort2(second);
        MetaColumn.merge2(first, second, wheeler);
        return result;
    }

    private static void merge2(Vector<DataColumn> firstHalf, Vector<DataColumn> secondHalf, Vector<DataColumn> result) {
        int indexFirst = 0;
        int indexSecond = 0;
        while (indexFirst < firstHalf.size() && indexSecond < secondHalf.size()) {
            int sa = firstHalf.get((int)indexFirst).myNum;
            int sb = secondHalf.get((int)indexFirst).myNum;
            if (sa < sb) {
                result.add(firstHalf.get(indexFirst));
                ++indexFirst;
                continue;
            }
            result.add(secondHalf.get(indexSecond));
            ++indexSecond;
        }
        while (indexFirst < firstHalf.size()) {
            result.add(firstHalf.get(indexFirst));
            ++indexFirst;
        }
        while (indexSecond < secondHalf.size()) {
            result.add(secondHalf.get(indexSecond));
            ++indexSecond;
        }
    }

    public class SubColumnListModel
    implements ListModel {
        protected Vector listeners = new Vector();

        @Override
        public void addListDataListener(ListDataListener ldl) {
            this.listeners.add(ldl);
        }

        public Object getElementAt(int i) {
            return MetaColumn.this.subColumns.get(i).getName();
        }

        @Override
        public int getSize() {
            return MetaColumn.this.subColumns.size();
        }

        @Override
        public void removeListDataListener(ListDataListener ldl) {
            this.listeners.remove(ldl);
        }

        public void fireColumnsAdded(int low, int high) {
            ListDataEvent lde = new ListDataEvent(this, 1, low, high);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((ListDataListener)iter.next()).intervalAdded(lde);
            }
        }

        public void fireColumnsRemoved(int low, int high) {
            ListDataEvent lde = new ListDataEvent(this, 2, low, high);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((ListDataListener)iter.next()).intervalRemoved(lde);
            }
        }

        public void fireColumnChanged(DataColumn col) {
            int index = MetaColumn.this.subColumns.indexOf(col);
            if (index >= 0) {
                this.fireColumnChanged(index);
            }
        }

        public void fireColumnChanged(int col) {
            ListDataEvent lde = new ListDataEvent(this, 0, col, col);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((ListDataListener)iter.next()).contentsChanged(lde);
            }
        }

        public void fireContentsChanged() {
            ListDataEvent lde = new ListDataEvent(this, 0, 0, MetaColumn.this.subColumns.size());
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ((ListDataListener)iter.next()).contentsChanged(lde);
            }
        }
    }

    class footer {
        public StringWrappingInfo colName;
        public StringWrappingInfo colInfo;
        public double maxFontHeight;
        public double maxHeight;

        public footer(ImageGenerator ig, DataColumn col, double width) {
            this.colName = ig.wrapString(col.getName() + " :: ", width / 5.0 - 30.0, MetaColumn.this.fonts.getFont(12), MetaColumn.this.fileInfo);
            this.colInfo = ig.wrapString(col.popup, 4.0 * width / 5.0 - 30.0 - 20.0, MetaColumn.this.fonts.getFont(13), MetaColumn.this.fileInfo);
            this.maxHeight = Math.max(this.colName.getHeight(), this.colInfo.getHeight());
            this.maxFontHeight = Math.max(this.colName.getFontHeight(), this.colInfo.getFontHeight());
            MetaColumn.this.FOOTER_HEIGHT += this.maxHeight + this.maxFontHeight;
            MetaColumn.this.COL_NAME_WIDTH = Math.max(MetaColumn.this.COL_NAME_WIDTH, this.colName.getWidth());
        }
    }
}

